VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "U3800 Get Vector Correction Data V1.0"
   ClientHeight    =   9150
   ClientLeft      =   1530
   ClientTop       =   1410
   ClientWidth     =   11370
   Icon            =   "Form1.frx":0000
   MaxButton       =   0   'False
   ScaleHeight     =   9150
   ScaleWidth      =   11370
   Begin VB.Frame Frame3 
      Caption         =   "Vector Correction"
      Height          =   5655
      Left            =   7680
      TabIndex        =   27
      Top             =   2400
      Width           =   3495
      Begin VB.Frame Frame4 
         Caption         =   "Correction Mode"
         Height          =   1695
         Left            =   600
         TabIndex        =   28
         Top             =   1440
         Width           =   2295
         Begin VB.ComboBox CaptureBW 
            Height          =   315
            Left            =   1200
            TabIndex        =   21
            Text            =   "Combo1"
            Top             =   1080
            Width           =   975
         End
         Begin VB.OptionButton Get_Current_Corr 
            Caption         =   "Get Current Correction"
            Height          =   255
            Left            =   120
            TabIndex        =   20
            Top             =   720
            Width           =   1935
         End
         Begin VB.OptionButton Get_Inband_Corr 
            Caption         =   "Get Inband Correction"
            Height          =   255
            Left            =   120
            TabIndex        =   19
            Top             =   360
            Value           =   -1  'True
            Width           =   1935
         End
         Begin VB.Label CapbwLabel 
            Caption         =   "Capture BW:"
            Height          =   255
            Left            =   240
            TabIndex        =   32
            Top             =   1140
            Width           =   1095
         End
      End
      Begin VB.CommandButton cmdRecallVecCorr 
         Caption         =   "Recall"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   735
         Left            =   600
         TabIndex        =   5
         Top             =   4560
         Width           =   2295
      End
      Begin VB.CommandButton cmdStopVecCorr 
         Caption         =   "Stop"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   735
         Left            =   600
         TabIndex        =   4
         Top             =   3360
         Width           =   2295
      End
      Begin VB.CommandButton cmdGetVecCorr 
         Caption         =   "Get Correction"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   735
         Left            =   600
         TabIndex        =   3
         Top             =   480
         Width           =   2295
      End
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   9720
      Top             =   8280
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin MSWinsockLib.Winsock tcpClient 
      Left            =   8520
      Top             =   8280
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.Frame AutoFreqRange 
      Caption         =   "Auto Frequency Range"
      Height          =   2295
      Left            =   4560
      TabIndex        =   25
      Top             =   1920
      Width           =   2655
      Begin VB.TextBox OffsetFreq 
         Height          =   285
         Left            =   1440
         TabIndex        =   14
         Top             =   1800
         Width           =   495
      End
      Begin VB.CheckBox chkRange8G 
         Caption         =   "6GHz-----8GHz"
         Height          =   255
         Left            =   360
         TabIndex        =   13
         Top             =   1440
         Width           =   1815
      End
      Begin VB.CheckBox chkRange6G 
         Caption         =   "3GHz-----6GHz"
         Height          =   300
         Left            =   360
         TabIndex        =   12
         Top             =   1080
         Width           =   1815
      End
      Begin VB.CheckBox chkRange3G 
         Caption         =   "1GHz-----3GHz"
         Height          =   255
         Left            =   360
         TabIndex        =   11
         Top             =   720
         Width           =   1815
      End
      Begin VB.CheckBox chkRange1G 
         Caption         =   "10MHz---1GHz"
         Height          =   255
         Left            =   360
         TabIndex        =   10
         Top             =   360
         Width           =   1815
      End
      Begin VB.Label Label3 
         Caption         =   "MHz"
         Height          =   255
         Left            =   2040
         TabIndex        =   34
         Top             =   1830
         Width           =   495
      End
      Begin VB.Label Label2 
         Caption         =   "Offset Freq:"
         Height          =   255
         Left            =   480
         TabIndex        =   33
         Top             =   1830
         Width           =   975
      End
   End
   Begin VB.Frame CF 
      Caption         =   "Table Input Mode"
      Height          =   1215
      Left            =   4560
      TabIndex        =   24
      Top             =   480
      Width           =   2655
      Begin VB.OptionButton CFManual 
         Caption         =   "Manual"
         Height          =   255
         Left            =   360
         TabIndex        =   9
         Top             =   720
         Width           =   1455
      End
      Begin VB.OptionButton CFAuto 
         Caption         =   "Auto"
         Height          =   255
         Left            =   360
         TabIndex        =   8
         Top             =   360
         Value           =   -1  'True
         Width           =   1455
      End
   End
   Begin VB.Frame Frame1 
      Height          =   1455
      Left            =   7680
      TabIndex        =   29
      Top             =   120
      Width           =   3495
      Begin VB.TextBox txtIPAddress 
         Height          =   270
         Left            =   1200
         TabIndex        =   7
         Top             =   240
         Width           =   1815
      End
      Begin VB.CommandButton cmdClose 
         Caption         =   "Close"
         Height          =   495
         Left            =   1800
         TabIndex        =   6
         Top             =   720
         Width           =   1455
      End
      Begin VB.CommandButton cmdConnect 
         Caption         =   "Connect"
         Height          =   495
         Left            =   240
         TabIndex        =   0
         Top             =   720
         Width           =   1335
      End
      Begin VB.Label Label5 
         Caption         =   "IP Address:"
         Height          =   255
         Left            =   240
         TabIndex        =   30
         Top             =   270
         Width           =   975
      End
   End
   Begin VB.Frame CFT 
      Caption         =   "Correction Table"
      Height          =   8775
      Left            =   240
      TabIndex        =   22
      Top             =   120
      Width           =   7215
      Begin VB.TextBox txtCF 
         Height          =   270
         Left            =   5160
         TabIndex        =   15
         Top             =   4680
         Width           =   1575
      End
      Begin VB.Frame Frame2 
         Caption         =   "Manual setup"
         Height          =   2055
         Left            =   4320
         TabIndex        =   26
         Top             =   4320
         Width           =   2655
         Begin VB.TextBox txtFileHeader 
            Height          =   270
            Left            =   1200
            TabIndex        =   18
            Top             =   1560
            Width           =   1215
         End
         Begin VB.CheckBox chkHeader 
            Caption         =   "Header:"
            Height          =   255
            Left            =   120
            TabIndex        =   17
            Top             =   1560
            Width           =   1095
         End
         Begin VB.TextBox txtFileName 
            Height          =   270
            Left            =   840
            TabIndex        =   16
            Top             =   960
            Width           =   1575
         End
         Begin VB.Label Label6 
            Caption         =   "(.dat file)"
            Height          =   255
            Left            =   120
            TabIndex        =   36
            Top             =   1110
            Width           =   735
         End
         Begin VB.Label Label4 
            Caption         =   "CF(MHz):"
            Height          =   255
            Left            =   120
            TabIndex        =   35
            Top             =   360
            Width           =   735
         End
         Begin VB.Label Label1 
            Caption         =   "Name:"
            Height          =   255
            Left            =   120
            TabIndex        =   31
            Top             =   840
            Width           =   615
         End
      End
      Begin VB.CommandButton cmdDelete 
         Caption         =   "Delete"
         Height          =   615
         Left            =   4680
         TabIndex        =   2
         Top             =   7680
         Width           =   1815
      End
      Begin MSFlexGridLib.MSFlexGrid CFTable 
         Height          =   8175
         Left            =   240
         TabIndex        =   23
         Top             =   360
         Width           =   3930
         _ExtentX        =   6932
         _ExtentY        =   14420
         _Version        =   393216
         Rows            =   201
         FixedCols       =   0
      End
      Begin VB.CommandButton cmdSet 
         Caption         =   "Set Table"
         Height          =   615
         Left            =   4680
         TabIndex        =   1
         Top             =   6720
         Width           =   1815
      End
   End
   Begin VB.Menu mnu 
      Caption         =   "File"
      Begin VB.Menu mnusave 
         Caption         =   "Save Correction Table"
      End
      Begin VB.Menu mnuopen 
         Caption         =   "Open Correction Table"
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit


'*-------------------------------------------------------------------------------------------
'*.Program Name :        U3800 Get Vetctor Correction Data
'*
'*      Sample software for Advantest Spectrum Analyzer U3800
'*
'*.Description :
'*
'*.Revision History :
'*      1.00(Beta)     25-SEP-2012       First Release by Honda
'*                     ----------------------------------------------------------------------
'*
'*      1.00           10-Oct-2012       V1.00 Release by Hirakoso
'*                     ----------------------------------------------------------------------
'*                     >Change the Correcrion lower limit Frequency 0Hz to 10MHz.
'*                     >Add the Offset Frequnecy. (CF = CF + OFS)
'*                     >Add the menu of Get Current Corr Data.
'*                     >Add the Power On Recall (Measurement Conditions).
'*
'*
'*----------------------------------------------------------------------
'*.Copyright(c) 2012 ADVANTEST CORPORATION
'*.http://www.advantest.co.jp
'*----------------------------------------------------------------------

Private Sub SetCaptureBW()

    CaptureBW.Text = "Select"
    CaptureBW.AddItem "Select"
    CaptureBW.AddItem " 40M"
    CaptureBW.AddItem " 30M"
    CaptureBW.AddItem " 10M"
    CaptureBW.AddItem " 3M"
    CaptureBW.AddItem " 1M"
    CaptureBW.AddItem " 300K"
    CaptureBW.AddItem " 100K"
    CaptureBW.AddItem " 30K"
    CaptureBW.AddItem " 10K"
    CaptureBW.AddItem " 1K"
    CaptureBW.AddItem " 300"
    CaptureBW.AddItem " 100"

End Sub

Private Sub CFAuto_Click()

    AutoFreqRange.Enabled = True
    chkRange1G.Enabled = True
    chkRange3G.Enabled = True
    chkRange6G.Enabled = True
    chkRange8G.Enabled = True
    Label2.Enabled = True
    Label3.Enabled = True
    OffsetFreq.Enabled = True

End Sub

Private Sub CFManual_Click()

    AutoFreqRange.Enabled = False
    chkRange1G.Enabled = False
    chkRange3G.Enabled = False
    chkRange6G.Enabled = False
    chkRange8G.Enabled = False
    Label2.Enabled = False
    Label3.Enabled = False
    OffsetFreq.Enabled = False

End Sub

Private Sub chkHeader_Click()
    If chkHeader.Value = 1 Then
        txtFileHeader.Enabled = True
    Else
        txtFileHeader.Enabled = False
    End If
End Sub

Private Sub cmdClose_Click()
    Dim iintLoop As Integer, ErrRet As Integer

    ErrRet = SendDtFunc("GTL" & vbLf)
    tcpClient.Close
    cmdConnect.Enabled = True
    cmdConnect.Default = True
    txtIPAddress.Enabled = True
    
    SetupLAN = 0                                ' Clear connect flag

    cmdClose.Enabled = False
End Sub

Private Sub cmdConnect_Click()
    Dim Sp As String
    Dim SendDt As String
    
    If Trim$(txtIPAddress.Text) <> "" Then
                                                 'AvP[Vɐڑv𑗐M܂
        tcpClient.Protocol = sckTCPProtocol
        tcpClient.LocalPort = 0
        tcpClient.RemoteHost = txtIPAddress.Text
        tcpClient.RemotePort = "5025"
        tcpClient.Connect
            
        Do While (tcpClient.BytesReceived = 0)
            DoEvents
        Loop
        tcpClient.GetData Sp
        SendDtFunc ("REN")
        
        cmdConnect.Enabled = False
        cmdClose.Enabled = True
        SetupLAN = 1                                ' set connect flag
    Else
        MsgBox "Please input the IP Address"
        SetupLAN = 0                                ' Clear connect flag
    End If
End Sub


Private Sub cmdDelete_Click()
    Dim lRow As Long
    Dim lCurrentRow As Long
    Dim lRowSel As Long
    Dim lCurrentTopRow As Long
    Dim temp As Long
    Dim i As Long
    Dim j As Long
    Dim lDeleteRows As Long
    
    Dim CellColor As Long
    Dim freq As String
    Dim datFile As String
    
    On Error GoTo errhandler

    With CFTable
        .Redraw = False
        lCurrentRow = .Row
        lCurrentTopRow = .TopRow
        lRowSel = .RowSel
        
        If lRowSel < lCurrentRow Then
            temp = lRowSel
            lRowSel = lCurrentRow
            lCurrentRow = temp
        End If
        
        lDeleteRows = lRowSel - lCurrentRow + 1

        For lRow = lRowSel + 1 To .Rows - 1
            .Row = lRow
            CellColor = CFTable.CellBackColor
            .Col = 0
            freq = .Text
            .Col = 1
            datFile = .Text

            .Row = lRow - lDeleteRows
            .Col = 0
            .Text = freq
            .CellBackColor = CellColor
            .Col = 1
            .Text = datFile
            .CellBackColor = CellColor

        Next lRow
        
        'cs͋
        For lRow = .Rows - lDeleteRows To .Rows - 1
            .Row = lRow
            .Col = 0
            .Text = ""
            .CellBackColor = vbDefault
            .Col = 1
            .Text = ""
            .CellBackColor = vbDefault
        Next lRow
        
        .Row = lCurrentRow
        .RowSel = .Row
        .Col = 0
        .ColSel = 1
        
        
        If lDeleteRows > 35 Then
            If lCurrentTopRow < lCurrentRow Then
                .TopRow = lCurrentTopRow
            Else
                .TopRow = lCurrentRow
            End If
        End If
        
    End With
    
errhandler:
   CFTable.Redraw = True
        
End Sub

Private Sub cmdGetVecCorr_Click()
    Dim SendDt As String, ErrRet As Integer
    Dim i As Integer
    Dim FileFooter As Integer
    Dim p As Integer
    Dim lRow As Long
    Dim ret As Integer
    Dim CAPBW As String
    

    If SetupLAN = 1 Then                                    'Connect is OK
        StopVecCorrFlag = False
        CFTable.TopRow = 1
        CFTable.Redraw = False
        For lRow = 1 To CFTable.Rows - 1
            CFTable.Row = lRow
            CFTable.Col = 0
            CFTable.CellBackColor = vbDefault
            CFTable.Col = 1
            CFTable.CellBackColor = vbDefault

            CFTable.Row = 1
            CFTable.Col = 0
            CFTable.ColSel = 1
        Next lRow
        CFTable.Redraw = True
        
        MsgBox "Connect the calibrator to CH1 and CH2 connector." & vbCrLf & "Then press OK to continue."
        
        CFTable.HighLight = flexHighlightNever
        Screen.MousePointer = vbArrowHourglass
        cmdClose.Enabled = False
        cmdSet.Enabled = False
        cmdDelete.Enabled = False
        cmdRecallVecCorr.Enabled = False
        cmdGetVecCorr.Enabled = False
        cmdStopVecCorr.Enabled = True
        
        SendDtFunc ("REN")
        SendDtFunc ("SYSMODE SYNC")                         'SYSTEM MODE SYNC
        
        SendDtFunc ("XPRPDON OFF")
        SendDtFunc ("XDIFFON OFF")
        SendDtFunc ("CHPDIFON OFF")
        SendDtFunc ("XMATHON ON")                           'Math Execute ON
        SendDtFunc ("VCSIGSRC INT")                         'Signal Source INT
        
        If Get_Current_Corr.Value = True Then               'Current Vector Correction?
            CAPBW = CaptureBW.Text
            If CAPBW <> "Select" Then                       'No select --> Skip
                CAPBW = "XCAPBW" & CAPBW & "Z"              'Header + Freq + Unit
                SendDtFunc (CAPBW)
            End If
        End If
        
        SendDtFunc ("FILEFORMAT BIN")                       'File Format BIN
        SendDtFunc ("FILEMEDIA FLASH")                      'Media FLASH
        
        SendDtFunc ("RFC RFC1")                             'Input RF Connector L-INPUT
        
        'Inband Correction TableɂāA󔒍sɓB܂Vector CorrectionsB
        For lRow = 1 To CFTable.Rows - 1
            If StopVecCorrFlag = True Then Exit For
            If CFTable.TextMatrix(lRow, 0) <> "" And CFTable.TextMatrix(lRow, 1) <> "" Then
                SendDt = "CF" + CFTable.TextMatrix(lRow, 0) + "MZ"     'Center Frequency
                SendDtFunc (SendDt)
                SendDtFunc ("*CLS")
                
                If Get_Inband_Corr.Value = True Then        'Inband Corr? Yes >>
                    SendDtFunc ("VCINBEXE")                 'Vector Correction: Get Inband Corr Data
                Else
                    SendDtFunc ("VCSMPLEXE")                'Vector Correction: Get Current Corr Data
                End If
                
                Direct_CAL_End 500, 60
                SendDt = "SV:dat/" + CFTable.TextMatrix(lRow, 1) + ".dat"
                SendDtFunc (SendDt)                                             'Save dat file

                CFTable.Redraw = False
                CFTable.Row = lRow
                CFTable.Col = 0
                CFTable.CellBackColor = vbYellow
                CFTable.Col = 1
                CFTable.CellBackColor = vbYellow

                CFTable.Row = lRow
                CFTable.Col = 0
                CFTable.ColSel = 1
                
                If lRow >= 35 Then
                    CFTable.TopRow = lRow - 33
                End If
               
                CFTable.Redraw = True
            Else
                Exit For
            End If
        Next lRow
        
        Screen.MousePointer = vbDefault
        CFTable.HighLight = flexHighlightAlways
        cmdClose.Enabled = True
        cmdSet.Enabled = True
        cmdDelete.Enabled = True
        cmdRecallVecCorr.Enabled = True
        cmdGetVecCorr.Enabled = True
        cmdStopVecCorr.Enabled = False
    Else
        MsgBox "Please open the LAN: Connect button..."
    End If
End Sub

Private Sub cmdRecallVecCorr_Click()
    Dim SendDt As String
    Dim lRow As Long
    Dim ret As Integer
    
    If SetupLAN = 1 Then        ' Connect is OK
        CFTable.RowSel = CFTable.Row
        lRow = CFTable.Row
        If CFTable.TextMatrix(lRow, 1) <> "" Then
            SendDtFunc ("REN")
            SendDtFunc ("RCTRC OFF")    'Recall Items Trace
            SendDtFunc ("RCVCORR ON")   'Recall Items Vector Correction
            SendDt = "RC:dat/" + CFTable.TextMatrix(lRow, 1) + ".dat"
            SendDtFunc (SendDt)
        End If
    Else
        MsgBox "Please open the LAN: Connect button..."
    End If
    
End Sub

Private Sub cmdSet_Click()
    Dim lRow As Long
    Dim freq As String
    Dim datFile As String
    Dim header As String
    Dim ret As VbMsgBoxResult
    Dim iStartIndex As Integer
    Dim OffsetFreqData As Double
    
    With CFTable
        If CFAuto.Value = True Then 'Auto Input
            If chkRange1G.Value <> 1 And chkRange3G.Value <> 1 And chkRange6G.Value <> 1 And chkRange8G.Value <> 1 Then
                MsgBox "Auto Frequency Range is not specified."
            Else
                ret = MsgBox("Table is Cleared and filled with default data." & vbCrLf & "Then press OK to continue.", vbOKCancel)
                If ret = vbOK Then
                    .Redraw = False
                    'e[uZbg
                    .Clear
                    .Col = 0
                    .Row = 0
                    .Text = "CF(MHz)"
                    .CellAlignment = flexAlignCenterCenter
                    
                    .Col = 1
                    .Row = 0
                    .Text = "File name"
                    .CellAlignment = flexAlignCenterCenter
                    
                    .Row = 1
                    .Col = 0
                    .ColSel = 1
                    
                    'IꂽgWɏ]āAIInband Correction TableZbg
                    iStartIndex = 1
                    
                    '-------------------------------------------------------'Add Offset Frequency
                    OffsetFreqDsp = Val(OffsetFreq.Text)                    'Text to Integer
                    If OffsetFreqDsp > 21 Then OffsetFreqDsp = 20           'Upper Limit
                    If OffsetFreqDsp < -21 Then OffsetFreqDsp = -20         'Lower Limit
                    OffsetFreq.Text = OffsetFreqDsp                         'Display
                    OffsetFreqData = OffsetFreqDsp                          'Integer to Double
                    OffsetFreqData = OffsetFreqData * 1000000               'MHz to Hz unit...
                    
                    If chkRange1G.Value = 1 Then
                        SetTable iStartIndex, OffsetFreqData + 30000000#, 25, 30 + OffsetFreqDsp
                        iStartIndex = iStartIndex + 25
                    End If
                    
                    If chkRange3G.Value = 1 Then
                        SetTable iStartIndex, OffsetFreqData + 1020000000#, 50, 1020 + OffsetFreqDsp
                        iStartIndex = iStartIndex + 50
                    End If
                    
                    If chkRange6G.Value = 1 Then
                        SetTable iStartIndex, OffsetFreqData + 3020000000#, 75, 3020 + OffsetFreqDsp
                        iStartIndex = iStartIndex + 75
                    End If
                    
                    If chkRange8G.Value = 1 Then
                        SetTable iStartIndex, OffsetFreqData + 6020000000#, 50, 6020 + OffsetFreqDsp
                    End If
                    
                    CFTable.TopRow = 1
                    .Redraw = True
                End If
            End If
        Else    'Manual Input
            freq = Trim(txtCF.Text)
            datFile = Trim(txtFileName.Text)
            header = Trim(txtFileHeader.Text)
            
            If freq <> "" And datFile <> "" Then
                .Redraw = False
                '󔒍sAݒ肵܂B
                For lRow = 1 To .Rows - 1
                    If .TextMatrix(lRow, 1) = "" Then
                        '.TextMatrix(lRow, 0) = Format(txtCF.Text, "####0")
                        .TextMatrix(lRow, 0) = txtCF.Text
                        If chkHeader.Value = 1 Then
                            datFile = txtFileHeader.Text + txtFileName.Text
                        Else
                            datFile = txtFileName.Text
                        End If
                        .TextMatrix(lRow, 1) = datFile
                        .Row = lRow
                        .Col = 0
                        .ColSel = 1
                        
                        If CFTable.TopRow > lRow Then
                            CFTable.TopRow = lRow
                        Else
                            If lRow - CFTable.TopRow >= 33 Then
                                CFTable.TopRow = lRow - 33
                            End If
                        End If
                        Exit For
                    End If
                Next lRow
                .Redraw = True
                If lRow = .Rows Then
                    MsgBox "Inband Correction Table is full."
                End If
            Else
            End If
        End If

    End With

End Sub

Private Sub File_Click(Index As Integer)

End Sub

Private Sub cmdStopVecCorr_Click()
    StopVecCorrFlag = True
End Sub

Private Sub Form_Load()
    SetupLAN = 0
    StopVecCorrFlag = False
    cmdClose.Enabled = False
    cmdStopVecCorr.Enabled = False
    
    txtFileName.MaxLength = 12
    txtFileHeader.MaxLength = 6
    txtCF.MaxLength = 11
    
    With CFTable
        .ColWidth(0) = 1200
        .ColWidth(1) = 2400
        .AllowBigSelection = False
        .SelectionMode = flexSelectionByRow
        .AllowUserResizing = flexResizeNone
        .ScrollBars = flexScrollBarVertical
        .FocusRect = flexFocusNone
        .HighLight = flexHighlightAlways
        .ScrollTrack = True
        
        .Col = 0
        .Row = 0
        .Text = "CF(MHz)"
        .CellAlignment = flexAlignCenterCenter
        
        .Col = 1
        .Row = 0
        .Text = "File name"
        .CellAlignment = flexAlignCenterCenter
        
        .Row = 1
        .Col = 0
        .ColSel = 1
 
    End With
    
    Call SetCaptureBW                                       'CompBox Display (CAPBW)
    
    Call InitRecall                                         'Recall conditions file...
    
    '------------------------- Setup Conditions ------------------------------
    
    CFAuto.Value = TableAutoFlag
    chkRange1G.Value = AutoFreq1Flag
    chkRange3G.Value = AutoFreq3Flag
    chkRange6G.Value = AutoFreq6Flag
    chkRange8G.Value = AutoFreq8Flag
    OffsetFreq.Text = OffsetFreqDsp
    txtCF.Text = ManualCF
    txtFileName.Text = ManualName
    chkHeader.Value = FileHeaderFlag
    txtFileHeader.Text = FileHeaderName
    Get_Inband_Corr.Value = GetInbandFlag
    txtIPAddress.Text = IPaddress
    
    '--------------- Display Enable/Disable ----------------
    
    If CFAuto.Value = True Then
        AutoFreqRange.Enabled = True
        chkRange1G.Enabled = True
        chkRange3G.Enabled = True
        chkRange6G.Enabled = True
        chkRange8G.Enabled = True
        Label2.Enabled = True
        Label3.Enabled = True
        OffsetFreq.Enabled = True
    Else
        CFManual.Value = True
        AutoFreqRange.Enabled = False
        chkRange1G.Enabled = False
        chkRange3G.Enabled = False
        chkRange6G.Enabled = False
        chkRange8G.Enabled = False
        Label2.Enabled = False
        Label3.Enabled = False
        OffsetFreq.Enabled = False
    End If
    
    If chkHeader.Value = 1 Then
        txtFileHeader.Enabled = True
    Else
        txtFileHeader.Enabled = False
    End If
    
    If Get_Inband_Corr.Value = True Then
        CapbwLabel.Enabled = False
        CaptureBW.Enabled = False
    Else
        Get_Current_Corr.Value = True
        CapbwLabel.Enabled = True
        CaptureBW.Enabled = True
    End If
    
    '-------------------------------------------------------
    
End Sub


Private Sub Form_Unload(Cancel As Integer)
    
    Call InitSave                               'Save conditions data...

    If SetupLAN = 1 Then
        tcpClient.Close
    End If
    
End Sub

Private Sub Get_Current_Corr_Click()

    CapbwLabel.Enabled = True
    CaptureBW.Enabled = True

End Sub

Private Sub Get_Inband_Corr_Click()

    CapbwLabel.Enabled = False
    CaptureBW.Enabled = False

End Sub

Private Sub mnuopen_Click()
    Dim fileno As Long
    Dim lRow As Long
    Dim buf1 As String
    Dim buf2 As String
    
    fileno = FreeFile                                 'FreeFile ɂt@CEI[vŎgpԍ擾
    
    On Error GoTo errhandler
    
    With CommonDialog1
        .InitDir = App.Path
        .CancelError = True
        .DialogTitle = "Open Correction Table"
        .Flags = cdlOFNHideReadOnly + cdlOFNLongNames
        .Filter = "All files(*.*)|*.*"

        'On Error GoTo errhandler
        .ShowOpen
        Open .FileName For Input As #fileno
    End With
    
    lRow = 1
    With CFTable
        Do Until EOF(fileno)
            Input #fileno, buf1, buf2
            .TextMatrix(lRow, 0) = buf1
            .TextMatrix(lRow, 1) = buf2
            lRow = lRow + 1
        Loop
        
        If lRow <= 200 Then
            Do Until lRow = .Rows
                .TextMatrix(lRow, 0) = ""
                .TextMatrix(lRow, 1) = ""
                lRow = lRow + 1
            Loop
        End If
        
        .Row = 1
        .RowSel = .Row
        .Col = 0
        .ColSel = 1
        .TopRow = 1
    End With
    
    
    Close #fileno
    On Error GoTo 0
    Exit Sub

errhandler:
    Close #fileno
    If Err.Number <> cdlCancel Then
        MsgBox "Error:" & Str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    End If
    On Error GoTo 0
End Sub

Private Sub mnusave_Click()
    Dim fileno As Long
    Dim lRow As Long
    
    fileno = FreeFile           'FreeFile ɂt@CEI[vŎgpԍ擾
    
    On Error GoTo errhandler
    
    With CommonDialog1
        .InitDir = App.Path
        .CancelError = True
        .DialogTitle = "Save Correction Table"
        .Flags = cdlOFNLongNames + cdlOFNOverwritePrompt
        .Filter = "csv files(*.csv)|*.csv"

        'On Error GoTo errhandler
        .ShowSave
        Open .FileName For Output As #fileno
    End With
    
    With CFTable
        For lRow = 1 To .Rows - 1
            If .TextMatrix(lRow, 0) = "" Then
                Exit For
            End If
            Print #fileno, .TextMatrix(lRow, 0) & ",";
            Print #fileno, .TextMatrix(lRow, 1)
        Next lRow
    End With
    
    Close #fileno
    On Error GoTo 0
    Exit Sub

errhandler:
    Close #fileno
    If Err.Number <> cdlCancel Then
        MsgBox "Error:" & Str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    End If
    On Error GoTo 0
End Sub

Private Sub OffsetFreq_KeyPress(KeyAscii As Integer)

    If KeyAscii = 13 Then
        OffsetFreqDsp = Val(OffsetFreq.Text)                    'Text to Integer
        If OffsetFreqDsp > 21 Then OffsetFreqDsp = 20           'Upper Limit
        If OffsetFreqDsp < -21 Then OffsetFreqDsp = -20         'Lower Limit
        OffsetFreq.Text = OffsetFreqDsp                         'Display
    End If

End Sub

Private Sub txtCF_LostFocus()
    txtCF.Text = Trim(txtCF.Text)
End Sub

Private Sub txtFileHeader_LostFocus()
    txtFileHeader.Text = Trim(txtFileHeader.Text)
End Sub

Private Sub txtFileName_LostFocus()
    txtFileName.Text = Trim(txtFileName.Text)
End Sub

